#version 330
 
in vec2 vUV;
in vec3 vVertex;
in vec3 vNormal;

smooth out vec2 vTexCoord;
smooth out vec4 color;

uniform mat3 N;
uniform mat4 MV;
uniform mat4 MVP;
uniform vec4 lightPos;
uniform vec4 mat_ambient;
uniform vec4 mat_diffuse;
uniform vec4 mat_specular;
uniform float mat_shininess;

uniform vec4 light_ambient;
uniform vec4 light_diffuse;
uniform vec4 light_specular; 
 
void main()
{
   vTexCoord = vUV;
   vec3 Nr = normalize(N*vNormal); //transform the normal vector by the normal matrix (inverse transpose of the modelview matrix)
   vec4 esPos = MV*vec4(vVertex,1);
   vec3 ecPosition3 = (vec3 (esPos.xyz)) / esPos.w;
   vec3 eye = vec3 (0.0, 0.0, 1.0);

   // Compute vector from surface to light position
   vec3 L = lightPos.xyz - ecPosition3;
  
   // Normalize the vector from surface to light position
   L = normalize(L);
   vec3 halfVector = normalize( eye + L);
 
   vec4 A = mat_ambient*light_ambient;
   float diffuse = max(dot(Nr,L),0.0);
   float pf=0;
   if (diffuse == 0.0)
   {
       pf = 0.0;
   }
   else
   {
       pf = max( pow(dot(Nr,halfVector), mat_shininess), 0.);

   }
   vec4 S = light_specular*mat_specular* pf;
   vec4 D = diffuse*mat_diffuse*light_diffuse;
   color = A + D + S;
   gl_Position = MVP*vec4(vVertex,1);
}

