/*
 * ---------------- www.spacesimulator.net --------------
 *   ---- Space simulators and 3d engine tutorials ----
 *
 * Author: Damiano Vitulli
 *
 * This program is released under the BSD licence
 * By using this program you agree to licence terms on spacesimulator.net copyright page
 *
 *
 * Rendering functions
 *  
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h> 
#include "camera.h"
#include "TextureMappedFont.h"
#include "framework.h"
#include "object.h"

#include "GLSLShader.h"
#include <iostream> 

using namespace std;

#include "mat_matr.h"
 
#ifdef USE_GLM
#include <glm/glm.hpp>
#include <glm/gtc/matrix_projection.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtc/type_ptr.hpp>
#endif

#ifdef USE_GLM
glm::mat4 
#else 	
matrix_4x4_type 
#endif
P;//projection matrix;

#include <vector>
extern vector<GLuint> vaoIDs;
extern vector<GLuint> vaoAABBIDs;


/*
 * VARIABLES DECLARATION
 *
 */

// Flag for rendering as lines or filled polygons
int render_filling=1; //0=OFF 1=ON

//Lights settings
GLfloat light_ambient[]= { 0.1f, 0.1f, 0.1f, 0.1f };
GLfloat light_diffuse[]= { 1.0f, 1.0f, 1.0f, 0.0f };
GLfloat light_specular[]= { 1.0f, 1.0f, 1.0f, 0.0f };
GLfloat light_position[]= { 100.0f, 0.0f, -10.0f, 1.0f };

//for aabb point colors
GLfloat white[4]={1,1,1,1};
GLfloat red[4]={1,0,0,1};
GLfloat green[4]={0,1,0,1};
GLfloat blue[4]={0,0,1,1};

//Materials settings
GLfloat mat_ambient[]= { 0.2f, 0.2f, 0.2f, 0.0f };
GLfloat mat_diffuse[]= { 1.0f, 1.0f, 1.0f, 0.0f };
GLfloat mat_specular[]= { 0.2f, 0.2f, 0.2f, 0.0f };
GLfloat mat_shininess[]= { 1.0f };

extern GLSLShader shader, aabb_shader;
// FPS calculation
extern unsigned int fps_physics;
extern unsigned int fps_rendering;
extern unsigned int set_fps_physics;

extern TextureMappedFont* font1;
extern TextureMappedFont* font2;
char l_string[MAX_PATH]={'\0'};

/*
 * void RenderInit(void)
 *
 * Used to initialize the Graphic library
 *  
 */


void RenderInit() {
	cout<<"Graphic library initialization"<<endl;
	MatrGenerateLookupTab();

	glGetError(); 
	glClearColor(0.0f,0.0f,0.2f,0.0f);	
	GL_CHECK_ERRORS
	
	glEnable(GL_DEPTH_TEST); // We enable the depth test (also called z buffer)
	glEnable(GL_CULL_FACE); // Enable the back face culling
	
	//glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST); // Texture mapping perspective correction (OpenGL... thank you so much!)
	//now shaders attributes are by default perspective correct
	GL_CHECK_ERRORS
    glPolygonMode (GL_FRONT_AND_BACK, GL_FILL); // Polygon rasterization mode (polygon filled)	
	GL_CHECK_ERRORS    
	  
}
#ifdef USE_GLM
void MatrMul_GLM( float* result, float* matrix, float* vector) {
	
	for(int j=0;j<4;j++)
	{
		float sum=0;
		for(int i=0;i<4;i++)
		{
			sum +=(matrix[i*4+j]*vector[i]);
		}
		result[j]= sum;
	}
}
#endif


/*
 * void RenderDisplay(void)
 *
 * This is our main rendering subroutine, called each frame
 *  
 */
void RenderDisplay() {
	GL_CHECK_ERRORS
	glClear(GL_COLOR_BUFFER_BIT| GL_DEPTH_BUFFER_BIT);
	//setup matrices
	
	for(int i=0;i<obj_qty;i++) {
		#ifdef USE_GLM
		glm::mat4 M		= glm::mat4(object[i].matrix[0][0],object[i].matrix[0][1], object[i].matrix[0][2], object[i].matrix[0][3],
							  object[i].matrix[1][0],object[i].matrix[1][1], object[i].matrix[1][2], object[i].matrix[1][3],
							  object[i].matrix[2][0],object[i].matrix[2][1], object[i].matrix[2][2], object[i].matrix[2][3],
							  object[i].matrix[3][0],object[i].matrix[3][1], object[i].matrix[3][2], object[i].matrix[3][3]);

		glm::mat4 V		= glm::mat4(camera.matrix[0][0],camera.matrix[0][1], camera.matrix[0][2], camera.matrix[0][3],
							  camera.matrix[1][0],camera.matrix[1][1], camera.matrix[1][2], camera.matrix[1][3],
							  camera.matrix[2][0],camera.matrix[2][1], camera.matrix[2][2], camera.matrix[2][3],
							  camera.matrix[3][0],camera.matrix[3][1], camera.matrix[3][2], camera.matrix[3][3]);
		glm::mat4 MV	= V*M;
		glm::mat3 N		= glm::transpose(glm::inverse(glm::mat3(MV)));
		glm::mat4 MVP	= P*MV;
		#else
		matrix_4x4_type N2,tmp, MVP, MV;
		matrix_3x3_type N;
		MatrIdentity_4x4(N2);
		MatrIdentity_4x4(MV);
		  
		MatrMul_4x4_4x4( object[i].matrix, camera.matrix,  MV);
		Fast_Inverse(MV, tmp);
		MatrCopy_3x3_trsp(N2,tmp);
		MatrCopy_4x4_3x3(N2, N);		 
		MatrMul_4x4_4x4(MV, P, MVP); 
		#endif

		//if(i==0)
			shader.Use();

		float centroid[4]={0, 0, 0, 1};
		float cs_pos[4]={0,0,0,1};
		#ifdef USE_GLM
		MatrMul_GLM(cs_pos, glm::value_ptr(MVP), centroid);
		#else
		MatrMul_Vec(cs_pos, MVP,  centroid);
		#endif
		
		cs_pos[0]/=cs_pos[3];		cs_pos[1]/=cs_pos[3];	cs_pos[2]/=cs_pos[3];	cs_pos[3]=1;
 		cs_pos[0]= (1+cs_pos[0])*hW;	
		cs_pos[1]= (1+cs_pos[1])*hH;	
		 
 
		#ifdef USE_GLM
		glUniformMatrix3fv(shader("N"), 1, GL_FALSE, glm::value_ptr(N));
		glUniformMatrix4fv(shader("MV"), 1, GL_FALSE, glm::value_ptr(MV));		
		glUniformMatrix4fv(shader("MVP"), 1, GL_FALSE, glm::value_ptr(MVP)); 
		#else
		glUniformMatrix3fv(shader("N"), 1, GL_FALSE, &N[0][0]);
		glUniformMatrix4fv(shader("MV"), 1, GL_FALSE, &MV[0][0]);		
		glUniformMatrix4fv(shader("MVP"), 1, GL_FALSE, &MVP[0][0]); 
		#endif
		if (object[i].id_texture!=-1) 
		{
			glBindTexture(GL_TEXTURE_2D, object[i].id_texture); // We set the active texture 		 
		}
		glUniform1i(shader("has_texture"), object[i].id_texture!=-1);
		
		glBindVertexArray(vaoIDs[i]);
			glDrawElements(GL_TRIANGLES, object[i].polygons_qty*3, GL_UNSIGNED_SHORT, 0);
		glBindVertexArray(0);
		shader.UnUse();

		//draw the aabb points
		aabb_shader.Use();
		#ifdef USE_GLM
		glUniformMatrix4fv(aabb_shader("MVP"), 1, GL_FALSE, glm::value_ptr(MVP)); 
		#else
		glUniformMatrix4fv(aabb_shader("MVP"), 1, GL_FALSE, &MVP[0][0]); 
		#endif

		glUniform4fv(aabb_shader("Color"),1, white);
		glBindVertexArray(vaoAABBIDs[i]);
			glDrawArrays(GL_POINTS, 0, 8);
		glBindVertexArray(0);
		aabb_shader.UnUse();

		//draw the font
		font2->DrawString((int)(cs_pos[0]), (int)(cs_pos[1]), object[i].name, (i==obj_control) );	
	}
	
	glBindTexture(GL_TEXTURE_2D, 0);

	// Print object information    
	sprintf_s(l_string,"Object selected: %s",object[obj_control].name);
	font1->DrawString(0,framework_screen_height-20,l_string, camera.matrix);
	sprintf_s(l_string,"Position: x=%.1f y=%.1f z=%.1f",object[obj_control].matrix[3][0], object[obj_control].matrix[3][1], object[obj_control].matrix[3][2]);
	font1->DrawString(0,framework_screen_height-40, l_string, camera.matrix);

	// Print FPS
	sprintf(l_string,"FPS physics: %u",fps_physics);
	font1->DrawString(0,framework_screen_height-60,l_string);
	sprintf(l_string,"FPS rendering: %u",fps_rendering);
	font1->DrawString(0,framework_screen_height-80,l_string);

	FrameworkSwapBuffers();
}
 

